// Simple example replay script
//
// Ole Hansen, 17 December 2013

{
  //--- Define the experimental configuration, i.e. spectrometers, detectors ---

  // For historical reasons, THaHRS automatically includes two
  // THaScintillators, "s1" and "s2", and one THaVDC, "vdc".

  gHaApps->Add( new THaHRS("L", "Left HRS" ));

  //--- Set up the run we want to replay ---

  // This often requires a bit of coding to search directories, test
  // for non-existent files, etc.

  int run_number = 3132;
  TString experiment = "g2p";

  TString data_dir = gSystem->Getenv("DATA_DIR");
  if( data_dir.IsNull() ) 
    data_dir = ".";
  TString run_file = data_dir + "/" + experiment + Form("_%d.dat.0",run_number);
  if( gSystem->AccessPathName(run_file) ) {
   Error("replay.C", "Input file does not exist: %s", run_file.Data() );
   return 1;
  }

  THaRun* run = new THaRun( run_file, "LHRS optics data" );

  // Define how many events we want to analyze. This is a property of the run
  // because the ranges of good events could be different for different runs
  int nev = -1;
  cout << "Number of events to replay (-1=all)? ";
  cin >> nev;
  if( nev > 0 )
    run->SetLastEvent(nev);
  
  //--- Set up any physics calculations we want to do ---

  // Extract the reconstructed target quantities of the golden track
  // Not really a physics calculation, but a convenience function.
  // It effectively converts the L.tr.* variables, which are arrays, 
  // to scalers L.gold.*

  gHaPhysics->Add( new THaGoldenTrack( "L.gold", "LHRS golden track", "L" ));

  // Single-arm electron kinematics for the one spectrometer we have set up.
  // We assume a carbon-12 target (12 AMU)
  gHaPhysics->Add( new THaPrimaryKine( "L.ekine", "LHRS electron kinematics",
				       "L", 0.511e-3, 12*0.9315 ));

  //--- Define what we want the analyzer to do ---
  // The only mandatory items are the output definition and output file names

  THaAnalyzer* analyzer = new THaAnalyzer;

  TString out_dir = gSystem->Getenv("OUT_DIR");
  if( out_dir.IsNull() )
    out_dir = ".";
  TString out_file = out_dir + "/" + experiment + Form("_%d.root", run_number);

  analyzer->SetOutFile( out_file );

  analyzer->SetCutFile( "replay.cdef" );
  analyzer->SetOdefFile( "replay.odef" );

  analyzer->SetVerbosity(2);  // write cut summary to stdout

  //--- Analyze the run ---
  // Here, one could replay more than one run with
  // a succession of Process calls. The results would all go into the
  // same ROOT output file

  analyzer->Process(run);

  // Clean up

  analyzer->Close();
  delete analyzer;
  gHaCuts->Clear();
  gHaVars->Clear();
  gHaPhysics->Delete();
  gHaApps->Delete();

  // Open the ROOT file so that a user doing interactive analysis can 
  // immediately look at the results. Of course, don't do this in batch jobs!
  // To close the file later, simply type "delete rootfile" or just exit

  TFile* rootfile = new TFile( out_file, "READ" );
}
