# Source this script to set up analysis in this directory
# Assumes ROOT is set up

drop_from_path()
{
   # Assert that we got enough arguments
   if test $# -ne 2 ; then
      echo "drop_from_path: needs 2 arguments"
      return 1
   fi

   p=$1
   drop=$2

   newpath=`echo $p | sed -e "s;:${drop}:;:;g" \
                          -e "s;:${drop};;g"   \
                          -e "s;${drop}:;;g"   \
                          -e "s;${drop};;g"`
}

if [ "x${BASH_ARGV[0]}" = "x" ]; then
    THIS="."
else
    THIS=$(dirname ${BASH_ARGV[0]})
    if [ "${THIS:0:1}" != "/" ]; then
	[ "${THIS}" = "." ] && unset THIS
	THIS=${THIS%/}
	THIS=$PWD/$THIS
	THIS=${THIS%/}
    fi
fi

export ANALYZER=${THIS}/analyzer
export DB_DIR=${THIS}/DB
export DATA_DIR=${THIS}/data
export OUT_DIR=${THIS}/rootfiles

if [ ! -d $ANALYZER -a -d ${THIS}/analyzer-1.6.0 ]; then
    ln -s ${THIS}/analyzer-1.6.0 $ANALYZER
fi

drop_from_path $PATH ${ANALYZER}
export PATH=${ANALYZER}:$newpath

if [ -n "${LD_LIBRARY_PATH}" ]; then
   drop_from_path $LD_LIBRARY_PATH ${ANALYZER}
   LD_LIBRARY_PATH=$newpath
fi
if [ -n "${DYLD_LIBRARY_PATH}" ]; then
   drop_from_path $DYLD_LIBRARY_PATH ${ANALYZER}
   export DYLD_LIBRARY_PATH=$newpath
fi
if [ -z "${LD_LIBRARY_PATH}" ]; then
   LD_LIBRARY_PATH=$ANALYZER
else
   LD_LIBRARY_PATH=$ANALYZER:$LD_LIBRARY_PATH
fi
if [ -z "${DYLD_LIBRARY_PATH}" ]; then
   DYLD_LIBRARY_PATH=$ANALYZER
else
   DYLD_LIBRARY_PATH=$ANALYZER:$DYLD_LIBRARY_PATH
fi
export LD_LIBRARY_PATH DYLD_LIBRARY_PATH
