#include "hks_hls_template.h"

ap_uint<1> multi_trg(
    ap_uint<256> fadc_hits,
    ap_uint<9> multiplicty_thr
  )
{
  ap_uint<9> hit_cnt = 0;

  for(int i=0;i<256;i++)
    hit_cnt+= fadc_hits[i] ? 1 : 0;

  if(hit_cnt >= multiplicty_thr)
    return 1;

  return 0;
}

ap_uint<1> or_trg(
    ap_uint<256> fadc_hits
  )
{
  return fadc_hits.or_reduce();
}

void hks_hls_template(
    ap_uint<9> multiplicty_thr,
    hls::stream<fadc_vxs_hits_t> &s_fadc_vxs_hits,
    hls::stream<trig_t> &s_trig
  )
{
#pragma HLS INTERFACE ap_fifo port=s_trig
#pragma HLS INTERFACE ap_fifo port=s_fadc_vxs_hits
#pragma HLS stable variable=multiplicty_thr
#pragma HLS PIPELINE II=1 style=flp
  trig_t trig;
  fadc_vxs_hits_t fadc_vxs_hits = s_fadc_vxs_hits.read();

  // since we're running with 31.25MHz clock, but
  // have 4ns resolution data we must perform 8 iterations per clock cycle
  for(int t=0;t<8;t++)
  {
    ap_uint<256> fadc_hits;
    for(int i=0;i<256;i++)
      fadc_hits[i] = fadc_vxs_hits.hits[i].hit[t];

    // you will likely want some kind of pulse stretching logic performed
    // before calling the trigger bit algorithms

    // Trigger bit 0: multiplicty trigger
    trig.trg[0][t] = multi_trg(fadc_hits, multiplicty_thr);

    // Trigger bit 1: or trigger
    trig.trg[1][t] = or_trg(fadc_hits);

    // Trigger bit 2 to 5: unused
    trig.trg[2][t] = 0;
    trig.trg[3][t] = 0;
    trig.trg[4][t] = 0;
    trig.trg[5][t] = 0;
  }

  // write 32ns worth of trigger decisions
  s_trig.write(trig);
}
