#include <stdlib.h>
#include <stdio.h>
#include "hks_hls_template.h"

#define TB_NUM_32NS_SAMPLES   100
#define HIT_P                 0.0001
#define MULTIPLICITY_THR      5

int main()
{
  ap_uint<9> multiplicty_thr = MULTIPLICITY_THR;
  hls::stream<fadc_vxs_hits_t> s_fadc_vxs_hits;
  hls::stream<trig_t> s_trig;
  hls::stream<trig_t> s_trig_answer;
  int result = 0;

  for(int i=0; i<TB_NUM_32NS_SAMPLES; i++)
  {
    fadc_vxs_hits_t fadc_vxs_hits;
    trig_t trig_answer;

    for(int t=0; t<8; t++)
    {
      ap_uint<1> trig_answer_or = 0;
      ap_uint<1> trig_answer_mult = 0;

      for(int trg=0; trg<TRIGGER_NUM; trg++)
        trig_answer.trg[trg][t] = 0;

      int mult_cnt = 0;
      for(int ch=0; ch<256; ch++)
      {
        fadc_vxs_hits.hits[ch].hit[t] = (drand48() < HIT_P) ? 1 : 0;
        if(fadc_vxs_hits.hits[ch].hit[t])
          mult_cnt++;
      }

      trig_answer.trg[0][t] = (mult_cnt >= multiplicty_thr) ? 1 : 0;
      trig_answer.trg[1][t] = (mult_cnt > 0)                ? 1 : 0;
    }
    s_trig_answer.write(trig_answer);
    s_fadc_vxs_hits.write(fadc_vxs_hits);
  }

  while(!s_fadc_vxs_hits.empty())
    hks_hls_template(multiplicty_thr, s_fadc_vxs_hits, s_trig);

  printf("s_trig_answer.size() = %d\n", s_trig_answer.size());
  printf("s_trig.size() = %d\n", s_trig.size());

  if(s_trig_answer.size() != s_trig.size())
  {
    printf("Error: s_trig_answer.size() != s_trig.size()\n");
    result = -1;
  }
  else
  {
    int t_32ns = 0;
    while(!s_trig.empty())
    {
      trig_t trig = s_trig.read();
      trig_t trig_answer = s_trig_answer.read();

      for(int t=0; t<8; t++)
      {
        for(int trg=0; trg<TRIGGER_NUM; trg++)
        {
          if(trig.trg[trg][t] != trig_answer.trg[trg][t])
          {
            printf("Error: @T=%d, trig[%d]=%d, trig_answer=%d\n", t_32ns+t, trg, (int)trig.trg[trg][t], (int)trig_answer.trg[trg][t]);
            result = -1;
          }
        }
      }
      t_32ns++;
    }
  }

  return result;
}
