#ifndef RAW_DATA_DUMPER_H
#define RAW_DATA_DUMPER_H

////////////////////////////////////////////////////
//
// raw_data_dumper
//
// tool to dump the raw data file
//
// daniel.joseph.antrim@cern.ch
// March 2017
//
////////////////////////////////////////////////////

#include <fstream>
#include <string>
#include <stdio.h>


class RawDataDumper
{
    public :
        RawDataDumper();
        virtual ~RawDataDumper(){};

        bool open_output_file(std::string filename, int run_number);

        bool fill_run_properties(double gain, int tac, int peak, int dac_threshold,
                int dac_pulser, int angle, double tp_skew);
        bool run_properties_written() { return m_has_run_properties; }

        bool write_data(uint32_t data);

        bool close_output_file();

    private :
        std::string m_filename;
        bool m_has_run_properties;
        bool m_ok_to_write;

        // this is the file
        //FILE *m_ofile;
        std::ofstream m_ofile;



};

#endif
