#ifndef CALIBRATION_STATE_H
#define CALIBRATION_STATE_H

#include <vector>


class CalibrationState {

    public :
        CalibrationState();
        virtual ~CalibrationState(){};

        int channel; // assumes channel 1-64
        double gain;
        int run_number;
        int tac_slope;
        int neighbor_trigger;
        int subhysteresis;
        int peak_time;
        int test_pulse;
        int dac_counts;
        std::vector<int> channel_trims;
        double tp_skew;
        int n_expected_pulses;

        void clear();
        void print();
};

#endif
