#ifndef MAINWINDOW_H
#define MAINWINDOW_H

// qt
#include <QMainWindow>
#include <QScrollArea>
#include <QGridLayout>
#include <QPushButton>
#include <QComboBox>
#include <QFont>
#include <QThread>
#include <QRadioButton>
#include <QTime>
class QListWidget;
class QListWidgetItem;

// vmm
#include "config_handler.h"
#include "configuration_module.h"
#include "run_module.h"
#include "socket_handler.h"
#include "data_handler.h"
#include "calibration_module.h"
#include "calibration_type.h"
#include "message_handler.h"
#include "daq_monitor.h"
#include "calibration_threshold_loader.h"

//std/stl
#include <string>
//dataflow
class DataFlowWindow;


const int MAX_N_IP=16;

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
    public:
        explicit MainWindow(QWidget *parent = 0);
        ~MainWindow();

        void load_cmdline_vmm_type(int type);
        void load_cmdline_config_xml(std::string file);
        void load_cmdline_daq_config_xml(std::string file);
        void load_cmdline_channel_trims_xml(std::string file);
        void load_cmdline_output_directory(std::string directory);
        void load_cmdline_comms(int n_feb = 0, int n_vmm = 0, int base_ip = 0);

        bool dbg() { return m_dbg; }

        bool eventFilter(QObject *obj, QEvent *event);


        QFont Font;
        QGridLayout *channelGridLayout;
        QWidget* dummy;
        void CreateChannelsFields();
        void CreateChannelsFieldsMulti();
        void SetInitialState();
        void InitializeChannelArrayValues();

        bool configOK() { return m_configOK; }

        //////////////////////////////////////////////////////
        // methods to grab the VMM tools
        //////////////////////////////////////////////////////
        ConfigHandler& configHandle() { return *vmmConfigHandler; }
        SocketHandler& socketHandle() { return *vmmSocketHandler; }
        Configuration& configModule() { return *vmmConfigModule;  }
        RunModule&     runModule()    { return *vmmRunModule;     }
        DataHandler&   dataHandle()   { return *vmmDataHandler;    }
        CalibModule&   calibModule()  { return *vmmCalibModule; }
        MessageHandler& msg()         { return *vmmMessageHandler; }
    
        //////////////////////////////////////////////////////
        // IPs
        //////////////////////////////////////////////////////
        QString ips[MAX_N_IP]; 
        void buildIPs();
        void IPaddressChange();

        /////////////////////////////////////////////////////
        // Channel Fields Buttons
        /////////////////////////////////////////////////////
        QLineEdit *VMMChannel[64];
        QComboBox *VMMSDVoltage[64];
        QComboBox *VMMSZ010bCBox[64];
        QComboBox *VMMSZ08bCBox[64];
        QComboBox *VMMSZ06bCBox[64];
    
        QPushButton *VMMSP[64];
        QPushButton *VMMNegativeButton[64];
        QPushButton *VMMSC[64];
        QPushButton *VMMSL[64];
        QPushButton *VMMST[64];
        QPushButton *VMMSTH[64];
        QPushButton *VMMSM[64];
        QPushButton *VMMSMX[64];
    
        //QPushButton *SPLabel;
        //QPushButton *SCLabel;
        //QPushButton *SLLabel;
        //QPushButton *STLabel;
        //QPushButton *SMLabel;
        //QComboBox *SDLabel;
        //QComboBox *SZ010bLabel;
        //QComboBox *SZ08bLabel;
        //QComboBox *SZ06bLabel;
        //QPushButton *SMXLabel;
    
        //QPushButton *SPLabel2;
        //QPushButton *SCLabel2;
        //QPushButton *SLLabel2;
        //QPushButton *STLabel2;
        //QPushButton *SMLabel2;
        //QComboBox *SDLabel2;
        //QComboBox *SZ010bLabel2;
        //QComboBox *SZ08bLabel2;
        //QComboBox *SZ06bLabel2;
        //QPushButton *SMXLabel2;
    
        bool VMMSCBool[64];
        bool VMMSLBool[64];
        bool VMMSTBool[64];
        bool VMMSTHBool[64];
        bool VMMSMBool[64];
        bool VMMSMXBool[64];
        bool VMMSPBool[64];
        int VMMSDValue[64];
        int VMMSZ010bValue[64];
        int VMMSZ08bValue[64];
        int VMMSZ06bValue[64];
    
        bool VMMSPBoolAll;
        bool VMMSCBoolAll;
        bool VMMSLBoolAll;
        bool VMMSTBoolAll;
        bool VMMSTHBoolAll;
        bool VMMSMBoolAll;
        bool VMMSMXBoolAll;
        bool VMMSZ010bBoolAll;
        bool VMMSZ08bBoolAll;
        bool VMMSZ06bBoolAll;
    
        bool VMMSPBoolAll2;
        bool VMMSCBoolAll2;
        bool VMMSLBoolAll2;
        bool VMMSTBoolAll2;
        bool VMMSTHBoolAll2;
        bool VMMSMBoolAll2;
        bool VMMSMXBoolAll2;
        bool VMMSZ010bBoolAll2;
        bool VMMSZ08bBoolAll2;
        bool VMMSZ06bBoolAll2;

        /////////////////////////////////
        // start/stop the run
        /////////////////////////////////
        bool do_l0_decoding();
        void startRun();
        void stopRun();

        /////////////////////////////////
        // toggle ability to change
        // daq configuration/mapping
        /////////////////////////////////
        void setDaqConfigurationEnabled(bool enable);

        /////////////////////////////////
        // calibration loop
        /////////////////////////////////
        //void startCalibration();
        bool is_calibration_setup();
        bool load_pulser_calib();
        bool load_pulser_calib_properties();
        void send_initial_config_to_pulser_calib();
        int setVMMsForCalib(CalibrationType type, int vmm_to_calib=-1);

        /////////////////////////////////
        // load calibration
        /////////////////////////////////
        bool performing_hard_reset(); // { return m_in_hard_reset; }
        bool load_thresholds() { return m_load_thresholds; }
        bool threshold_for_current_chip_loaded() { return m_current_chip_threshold_loaded; }
        void set_thresholds_for_current_chip();
        bool done_loading_thresholds() { return m_threshold_loading_finished; }

        /////////////////////////////////
        // VMM TYPE
        /////////////////////////////////
        int vmm_type();

        /////////////////////////////////
        // misc.
        /////////////////////////////////
        void delay();
        void delayMs();
    
    private:
        Ui::MainWindow *ui;

        int m_cmdline_vmm_type;
        std::string m_cmdline_config_xml;
        std::string m_cmdline_daq_config_xml;
        std::string m_cmdline_channel_trims_xml;
        std::string m_cmdline_output_directory;

        bool m_dbg;
        // dleay
        QTimer* m_timer;
        QTime m_start_run_time;

        // sets the GUI to whatever state
        // the ConfigHandle object is in
        void updateConfigState();

        //void setChannelsForCalib(int channel, bool do_channel_loop=true);
        void setChannelsForCalib(CalibrationType type, int channel, bool do_channel_loop=true);
        std::vector<int> getChannelTrims();

        void set_acq_mode_state(int on_or_off);

        bool ignore_channel_update;

        const int FECPORT;
        const int DAQPORT;
        const int VMMASICPORT;
        const int VMMAPPPORT;
        const int CLOCKSPORT;

        ConfigHandler *vmmConfigHandler;
        SocketHandler *vmmSocketHandler;
        Configuration *vmmConfigModule;
        RunModule     *vmmRunModule;
        DataHandler   *vmmDataHandler;
        CalibModule *vmmCalibModule;
        MessageHandler *vmmMessageHandler;

        std::vector<QRadioButton*> m_vmm_mask;

        // toggle for configuration
        bool m_in_hard_reset;

        // clocks need to be set initially
        bool clocks_have_been_set();
        std::vector<int> m_clocks_set; 

        // calibration
        bool m_calculate_total_steps;
        int n_total_steps_in_loop;
        int n_current_calibration_step;
        int n_calib_update_progress;
        int n_times_checked_progress;

        CalibrationThresholdLoader* m_calib_threshold_loader;
        bool m_load_thresholds;
        bool m_current_chip_threshold_loaded;
        bool m_threshold_loading_finished;
        std::string m_load_threshold_ip;
        int m_load_threshold_chip;


        // "FSM" stuff
        bool m_commOK;
        //addmmfe8
        bool m_febSetOK;
        bool m_configOK;
        bool m_tdaqOK;
        bool m_runModeOK;
        QString m_acqMode;
        bool m_daqInProgress;
        bool m_hdmiMaskON;
        bool m_runDirectoryOK;
        bool m_readyToRead;
        bool m_inCalibrationLoop;

        bool m_mapping_loaded_ok;

        bool m_is_calibration;

        bool m_have_loaded_pulser;

        QTime m_calib_time;
        double m_last_calib_time_check;
        //dataflow
        DataFlowWindow* m_dataflow_window;

    signals :
        //testMon
        void testMonitoringSignal();

        void checkFSM();
        void EndRun();

        // DataHandler related
        void monitorDataSignal(bool);
        void set_monitoring(bool, bool); // toggle to send data to monitoring app
        void send_monitor_config(); // signal to tell DH to send configuration
        void clearSharedMemory(int);
        void setWriteNtuple(bool);
        void setCalibrationRun(bool);
        void updateCalibrationState(int, int, int, int, int);
        void setupOutputFiles(QString, QString);
        void setupOutputTrees();
        void checkReadyToRead();
        void startDAQSocket();
        void closeDAQSocket();

    public slots:
        // VMM2 vs VMM3
        void set_interface_for_vmm_type();
        void set_interface_for_vmm_type(int);
        void set_l0_mode();
        void channel_trim_error_VMM2();

        // dac-to-mV
        void changeDACtoMVs(int);
        // ~"FSM"
        void updateFSM();

        // logging
        void readLog();

        // run c
        void activateRC();

        // run number
        void updateRunNumber(int);

        // counter
        void updateCounter();

        // event count for run has been reached
        void eventCountReached();

        // event count for when we have received CKTP MAX nubmer of packets
        void effCountReached();

        // VMM mask
        void updateVMMselection();

        // send the board configuration
        void prepareAndSendBoardConfig();

        // send the t/daq configuration
        void set_tdaq_configuration(bool);

        // defaults of trigger settings
        void set_trigger_settings_defaults();

        // clocks
        void set_clock_defaults();
        void send_clock_configuration();
        void update_tp_skew_label(int);

        // set the run mode and send
        void setTriggerMode();

        // send tdaq settings (latency, mode, "externalBC") to FE
        void send_tdaq_settings_command();

        // set the acquisition mode
        void setACQMode();

        // set the vmm power on vmmtb onlys
        void setVMMPower();

        // toggle the direct timing mode
        void setDirectTimingMode(int);

        // monitoring state
        void updateMonitoringState();

        void testMon();

        // select the output directory
        void selectOutputDirectory();

        // select the DAQ configuration/mapping file
        void selectDAQSetupFile();

        // load the DAQ configuration/mapping
        void loadDAQSetup();

        // turn off the ussage of the mapping/DAQ configuration
        void disableMapping();

        // update the IP info based on loaded DAQ config
        void updateIPs();

        // update the IP list if the IPs are changed, and force a reconnect
        void IPchanged(QString);
        void IPchanged(int);

        void checkRequestedFile();

        // select the config xml file
        void selectConfigXmlFile();

        // load a configuration from an XML
        void loadConfigurationFromFile();

        // write configuration to an XML file
        void writeConfigurationToFile();

        // clear the user comments field
        void clearUserComments();

        // number of FECs
        void setNumberOfFecs(int);

        // set board selection
        void updateBoardSelection(int);

        //ipset
        void setIPConfigurationState();
        bool okToChangeBoardIP();
        void toggleAllCommunication(bool enable);
        void sendIPConfiguration();

        // test xadc
        void send_test_xadc_configuration();
        
        // calibration
        void updateCalibrationState(bool is_start_of_run = false);
        void set_calibration();
        void set_calibration_loop_params();
        CalibrationType get_calibration_type();
        std::vector<int> get_selected_vmms_for_calibration();
        int get_first_selected_vmm();

        // calibration loading
        void selectCalibrationFile();
        void loadThresholdCalibrationFromFile();
        void disableThresholdCalibration();
        void printThresholdCalibration();


        /// remaining buttons/widgets

        //void setAndSendEventHeaders();
        void performHardReset();
        void performHardReset_VMM2();
        void triggerHandler();
        void updateLogScreen();
        void toggleDebug();

        // bad directory name
        void badRunDirectory();
        void setRunDirOK(bool);

        // channel fields
        void updateChannelState();
        void updateIndividualChannelState();
        void updateChannelVoltages(int);
        void updateChannelADCs(int);

        // trigger count
        void updateTriggerCount(int, int, unsigned int, unsigned int, bool);

        // connect to IP
        void Connect();

        // calibration-related
        void calibrationLoopState(bool);
        void setPDOCalibrationState(int,int,int);
        void setTDOCalibrationState(int,int,int,int);
        void changeDelayLabels(int);

        void stop_pulser_calib_run();

        // dataflow
        void enable_dataflow_monitor();
        void close_dataflow_window();

};


#endif // MAINWINDOW_H
