#ifndef CONFIGURATION_MODULE_H
#define CONFIGURATION_MODULE_H

/////////////////////////////////////////
//
// configuration_module
//
// Tool for building and sending the
// configuration packets to the front-end/
// VMMs
//
//  - sends the global SPI and configuration
//    of all the VMM channels
//
// daniel.joseph.antrim@cern.ch
// March 2016
//
//////////////////////////////////////////

// vmm
#include "config_handler.h"
#include "socket_handler.h"
#include "message_handler.h"

// Qt
#include <QString>


//////////////////////////////////////////////////////////////////////////////
// ------------------------------------------------------------------------ //
//  Configuration
// ------------------------------------------------------------------------ //
//////////////////////////////////////////////////////////////////////////////

class Configuration : public QObject
{
    Q_OBJECT

    public :
        explicit Configuration(QObject *parent = 0);
        virtual ~Configuration(){};
        Configuration& setDebug(bool dbg) { m_dbg = dbg; return *this; }
        bool dbg() { return m_dbg; }

        void set_vmm_type(int type) { m_vmm_type = type; }
        int vmm_type() { return m_vmm_type; }

        void LoadMessageHandler(MessageHandler& msg);
        MessageHandler& msg() { return *m_msg; }

        Configuration& LoadConfig(ConfigHandler& config);
        Configuration& LoadSocket(SocketHandler& socket);

        quint32 reverse32(QString binary_in);
        QString reverseString(QString string);
        void SendConfig();
        void fillGlobalRegisters(std::vector<QString>& globalRegisters);
        void fillChannelRegisters(std::vector<QString>& channelRegisters);

        void SendConfig_VMM2();
        void fillGlobalRegisters_VMM2(std::vector<QString>& globalRegisters);
        void fillChannelRegisters_VMM2(std::vector<QString>& channelRegisters);

        SocketHandler& socket() { return *m_socketHandler; }
        ConfigHandler& config() { return *m_configHandler; }

        // MMFE8 IP configuration
        std::string configureBoardIP(std::string current_ip, std::string new_ip, std::string daq_ip);
        std::string checkIpFormat(std::string full_ip, std::vector<std::string> ip_values, std::string from); 

    private :
        bool m_dbg;
        int m_vmm_type;
        bool m_use_custom;

        SocketHandler *m_socketHandler;
        ConfigHandler *m_configHandler;
        MessageHandler* m_msg;

    public slots :
        void send_configuration_pulser();


}; // class Configuration



#endif
