#ifndef FINE_CONFIGURATION_DESCRIPTOR_CHANNEL_H
#define FINE_CONFIGURATION_DESCRIPTOR_CHANNEL_H

//fine
#include "descriptor_base.h"

//std/stl
#include <string>
#include <map>
#include <vector>

namespace fine {

class DescriptorChannel : public DescriptorBase
{
    public :
        DescriptorChannel();
        virtual ~DescriptorChannel(){};

        void set_description(std::string description_string);
        std::string description_string() { return m_description_string; }

        std::map<std::string, int> desc_idx_map() { return m_description_map; }

        void set_board_id(int id) { m_board_id = id; }
        int board_id() { return m_board_id; }

        void set_vmm_id(int id) { m_vmm_id = id; }
        int vmm_id() { return m_vmm_id; }

        bool tree_has_board_id(int id = -1);
        bool tree_has_vmm_id(int id = -1);

        bool channel_register(int channel_number /*start from 0*/,
                    std::string register_name /*all caps*/, std::string & value);


    private :
        std::string m_description_string;
        std::map<std::string, int> m_description_map;
        int m_board_id;
        int m_vmm_id;

}; // class DescriptorChannel

} // namespace fine

#endif

