#include "fpga_clocks.h"
#include <iostream>
using namespace std;
#include <sstream>

const QStringList FPGAClocks::all_CKBC
    = { "40", "20", "10" }; // MHz


///////////////////////////////////////////////////////////////////////////////
FPGAClocks::FPGAClocks() :
    cktk_max_number(7),
    ckbc_frequency(0),
    cktp_max_number(65535),
    cktp_skew_steps(0),
    cktp_period(5000),
    cktp_width(4)
{
}
///////////////////////////////////////////////////////////////////////////////
void FPGAClocks::print()
{
    stringstream ss;
    ss << "FPGAClocks settings " << endl;
    ss << "    > cktk max number            : " << cktk_max_number << endl;
    ss << "    > ckbc frequency             : " << ckbc_frequency << endl;
    ss << "    > cktp max number            : " << cktp_max_number << endl;
    ss << "    > cktp skew                  : " << cktp_skew_steps << endl;
    ss << "    > cktp period                : " << cktp_period << endl;
    ss << "    > cktp width                 : " << cktp_width << endl;
    cout << ss.str() << endl;
}

