#include "descriptor_common.h"

//std/stl
#include <iostream>
#include <string>
#include <sstream>
using namespace std;

namespace fine {


DescriptorCommon::DescriptorCommon()
{
}

bool DescriptorCommon::global_register(string name, string& value)
{
    stringstream node;
    node << "vmm_common_config.global." << name;
    try {
        value = tree().get<string>(node.str());
    } 
    catch(std::exception& e) {
        cout << "DescriptorCommon::global_register    ERROR Could not find (common) global register \"" << name << "\": " << e.what() << endl;
        value = "";
        return false;
    }
    return true;
}

bool DescriptorCommon::channel_register(string name, string& value)
{
    stringstream node;
    node << "vmm_common_config.channel." << name;
    try {
        value = tree().get<string>(node.str());
    }
    catch(std::exception& e) {
        cout << "DescriptorCommon::channel_register    ERROR Could not find (common) channel register \"" << name << "\": " << e.what() << endl;
        value = "";
        return false;
    }
    return true;
}

} // namespace fine

