#include "descriptor_global.h"

//std/stl
#include <string>
#include <sstream>
#include <iostream>
using namespace std;

namespace fine {

DescriptorGlobal::DescriptorGlobal() :
    m_vmm_id(-1)
{
}

bool DescriptorGlobal::tree_has_board_id(int id)
{
    string test = "";
    stringstream node;
    node << "vmm_global_config.board_id";
    try {
        test = tree().get<string>(node.str());
    }
    catch(std::exception& e) {
        cout << "DescriptorGlobal::tree_has_board_id    ERROR Could not find the board id correctly: " << e.what() << endl;
        return false;
    }
    stringstream in;
    in << id;
    if(test == in.str())
        return true;
    else
        return false;
}

bool DescriptorGlobal::tree_has_vmm_id(int id)
{
    string test = "";
    stringstream node;
    node << "vmm_global_config.vmm_id";
    try {
        test = tree().get<string>(node.str());
    }
    catch(std::exception& e) {
        cout << "DescriptorGlobal::tree_has_vmm_id    ERROR Could not find the vmm id correctly: " << e.what() << endl;
        return false;
    }
    stringstream in;
    in << id;
    if(test == in.str())
        return true;
    else
        return false;
}

bool DescriptorGlobal::global_register(string name, string& value)
{
    stringstream node;
    node << "vmm_global_config.configuration." << name;
    try {
        value = tree().get<string>(node.str());
    }
    catch(std::exception& e) {
        cout << "DescriptorGlobal::global_register    ERROR Could not find (fine) global register \"" << name << "\": " << e.what() << endl;
        value = "";
        return false;
    }
    return true;
}

} // namespace fine
