#ifndef DATAFLOWWINDOW_H
#define DATAFLOWWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QCloseEvent>

//plot
#include "qcustomplot.h"

//std/stl
#include <sstream>
#include <queue>
#include <map>

namespace Ui {
class DataFlowWindow;
}

class DataFlowWindow : public QMainWindow
{
    Q_OBJECT

    public:
        explicit DataFlowWindow(QWidget *parent = 0);
        ~DataFlowWindow();
    
    private:
        Ui::DataFlowWindow *ui;
        QCPAxisRect* axes;

        QTimer dataTimer;
        QTimer sendTimer;

        bool dataflow_monitoring_stopped;

        // for counters

        unsigned int counter_input_empty_rate;
        unsigned int counter_input_hit_rate;
        int counter_record_hit_rate;
        int counter_record_trigger_rate;

        double last_count_input_empty_rate;
        double last_count_input_hit_rate;
        double last_count_record_hit_rate;
        double last_count_record_trigger_rate;

        float rate_input_empty_rate;
        float rate_input_hit_rate;
        float rate_record_hit_rate;
        float rate_record_trigger_rate;
    
        void initialize_graphs();

        float max_rate_seen;

        bool is_logy;
        bool use_khz;

        bool update_paused;

        QTime start_run_time;
        double lastPointKey;

        std::stringstream status_message;

        QSharedPointer<QCPAxisTickerLog> logTicker;
        QSharedPointer<QCPAxisTickerFixed> fixedTicker;

        std::queue<float> queue_for_max;
        std::priority_queue<float> priority_queue_for_max;

        float get_max_rate_seen();


        /////////////////////////////////////////
        // occupancy plot
        /////////////////////////////////////////

        int number_of_boards;

        int total_number_of_samples;

        // bar charts
        float maxy_occupancy_global;
        QCustomPlot *occPlot; 
        QCPBars* fullchart;
        QCPBars* nullchart;
        QSharedPointer<QCPAxisTickerText> occTextTicker;

        QSharedPointer<QCPAxisTickerLog> occLogTicker;
        QSharedPointer<QCPAxisTickerFixed> occFixedTicker;

        QVector<double> occTicks;
        QVector<QString> occLabels;

        // data containers
        std::map<int, int> board_idx_map;
        std::vector<float> data_occupancy;
        std::vector<float> data_null;
        QVector<double> qdata_occupancy;
        QVector<double> qdata_null;

        bool occupancy_update_paused;

        /////////////////////////////////////////
        // trigger delta plot
        /////////////////////////////////////////

        // bar charts
        QCustomPlot *trigDeltaPlot;
        QCPBars* deltachartup;
        QCPBars* deltachartdown;
        QSharedPointer<QCPAxisTickerText> deltaTextTicker;
        QSharedPointer<QCPAxisTickerLog> trigDeltaLogTicker;
        QSharedPointer<QCPAxisTickerFixed> trigDeltaFixedTicker;

        QVector<double> deltaTicks;
        QVector<QString> deltaLabels;

        std::vector<int> data_delta_zero;
        std::vector<int> data_delta_up;
        std::vector<int> data_delta_down;
        QVector<double> qdata_delta_up;
        QVector<double> qdata_delta_down;

        bool trig_delta_update_paused;

        int test_counter;


    public slots :

        void start_dataflow_monitor(int run_number, QTime start_time);
        void stop_dataflow_monitor();
        void update_counters(int, int, unsigned int, unsigned int);
        void set_logy();
        void set_lineary();
        void update_empty_count(unsigned int);
        void pause_update();

        void closeEvent(QCloseEvent* event);


        /////////////////////////////////////////
        // occupancy plot
        /////////////////////////////////////////
        void initialize_occupancy_plots(int, int); // initial board id from IP, number of boards
        void perform_occupancy_check(QString, int, int);
        void pause_occupancy_update();
        void set_logy_occupancy();

        ////////////////////////////////////////
        // trigger delta
        ////////////////////////////////////////
        void initialize_trig_delta_plots(int, int); // initial board id from IP, number of boards
        void perform_trigger_delta_check(int, int);
        void refresh_trig_delta();
        void pause_trig_delta_update();
        void set_logy_trigDelta();

    private slots :

        void update_monitor();
        void increment_counter();

    signals :
        void close_dataflow();

        
};

#endif // DATAFLOWWINDOW_H
