#include "calibration_state.h"
#include <iostream>
using std::cout;
using std::endl;



CalibrationState::CalibrationState()
{
    //channel = -1;
    //run_number = -1;
    //gain = -1;
    //tac_slope = -1;
    //neighbor_trigger = 2;
    //subhysteresis = 2;
    //peak_time = -1;
    //test_pulse = -1;
    //dac_counts = -1;
    //channel_trims.clear();
    clear();
}

void CalibrationState::clear()
{
    channel = -1;
    run_number = -1;
    gain = -1;
    tac_slope = -1;
    neighbor_trigger = 2;
    subhysteresis = 2;
    peak_time = -1;
    test_pulse = -1;
    dac_counts = -1;
    channel_trims.clear();
    for(int i = 0; i < 64; i++) channel_trims.push_back(-1);
    tp_skew = 0;
    n_expected_pulses = -1;
}

void CalibrationState::print()
{
    cout << "CalibrationState::print    channel: " << channel << endl;
    cout << "CalibrationState::print    run_number: " << run_number << endl;
    cout << "CalibrationState::print    gain: " << gain << endl;
    cout << "CalibrationState::print    tac_slope: " << tac_slope << endl;
    cout << "CalibrationState::print    neighbor_trigger: " << neighbor_trigger << endl;
    cout << "CalibrationState::print    subhysteresis: " << subhysteresis << endl;
    cout << "CalibrationState::print    peak_time: " << peak_time << endl;
    cout << "CalibrationState::print    test_pulse: " << test_pulse << endl;
    cout << "CalibrationState::print    dac_counts: " << dac_counts << endl;
    cout << "CalibrationState::print    channel trim: ";
    for(auto trim : channel_trims) cout << " " << trim;
    cout << endl;
    cout << "CalibrationState::print    n_expected_pulses: " << n_expected_pulses << endl;
    cout << "CalibrationState::print    tpSkew: " << tp_skew << endl;
}
