#include "trigger_daq.h"

#include <iostream>
#include <string>
#include <sstream>
using namespace std;


//////////////////////////////////////////////////////////////////////////////
// ------------------------------------------------------------------------ //
//  TriggerDAQ
// ------------------------------------------------------------------------ //
//////////////////////////////////////////////////////////////////////////////
TriggerDAQ::TriggerDAQ() :
    trigger_latency(0),         // FW default is 0x0000
    run_mode("pulser"),         // FW default is internal trigger
    fixed_tac(false),
    mapping_file(""),
    output_path(""),
    ok(false)
{
}
void TriggerDAQ::print()
{
    stringstream ss;

    ss << "------------------------------------------------------" << endl;
    ss << " Trigger/DAQ Settings " << endl;
    ss << "  trigger latency            : " << trigger_latency << endl;
    ss << "  mapping file               : " << mapping_file << endl;
    ss << "  output path                : " << output_path << endl;
    ss << "------------------------------------------------------" << endl;

    cout << ss.str() << endl;
}
