#ifndef ONLINEMONTOOL_H
#define ONLINEMONTOOL_H

/////////////////////////////////////////
//
// OnlineMonTool
//
//  Tool for setting up a QUdpSocket for
//  sending the data to the online monitoring
//  application.
//
//   - currently monitoring expects the event
//     data to be formatted as a string with
//     relevant data space-separated
//
// daniel.joseph.antrim@cern.ch
// August 2016
//
//////////////////////////////////////////

//std/stl
#include <string>
#include <vector>

// qt
#include <QObject>

// boost
#include <boost/asio.hpp>
#include <boost/thread.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>

class OnlineMonTool : public QObject
{

    Q_OBJECT

    public :
        explicit OnlineMonTool(QObject *parent = 0);
        virtual ~OnlineMonTool(){};

        void setDebug(bool doit) { m_dbg = doit; }
        bool dbg() { return m_dbg; }

        bool initialize(boost::shared_ptr<boost::asio::io_service> service);
        // set the address to where Monitoring application is hosted
        void setMonitorAddress(std::string ip, int port);

        void start();
        bool is_started() { return m_is_started; }
        void restart();
        void pause();
        bool is_paused() { return m_is_paused; }
        void stop(); // stop the timer and close the socket
        //void stopTimer(); // stop the timer only

        void addEventString(std::string event_string);
        void sendEventStrings();
        void send();
        void send_trig();
        void sendConfiguration(std::vector<std::string> words);
        void resetMonitoringConfiguration();
        bool configurationSent() { return m_configuration_sent; }
        void sendString(std::string event_string, bool is_config = false);

        void closeMonitoringSocket();

        void testMon();



    private :
        bool m_dbg;
        int n_warnings;
        int m_refresh_rate;

        //// boostifiy
        int m_bind_port;
        std::string m_monitor_ip;
        int m_monitor_port;
        bool m_accept_events;
        bool m_configuration_sent;
        bool m_is_started;
        bool m_is_paused;
        
        std::vector<std::string> m_event_string_vector;

        boost::shared_ptr<boost::asio::ip::udp::socket> m_socket;
        boost::shared_ptr<boost::asio::io_service> m_io_service;
        boost::shared_ptr<boost::asio::io_service::work> m_idle_work;
        boost::asio::ip::udp::endpoint m_remote_endpoint;

        //timer for callbacks
        boost::shared_ptr<boost::asio::deadline_timer> m_timer;

    public slots :
        

}; // class

#endif
