#include "daq_monitor.h"


// std/stl
#include <iostream>
#include <sstream>
using namespace std;

// qt
#include <QThread>

//////////////////////////////////////////////////////////////////////////////
// ------------------------------------------------------------------------ //
//  DaqMonitor
// ------------------------------------------------------------------------ //
//////////////////////////////////////////////////////////////////////////////
DaqMonitor::DaqMonitor(QObject* parent) :
    QObject(parent),
    m_dbg(false),
    m_is_monitoring(false),
    n_interval_to_check(2),
    n_previous_counter(-1),
    n_stuck_count(0),
    //n_live_counter( new int() ),
    n_live_counter(0),
    m_timer(0),
    m_msg(0)
{
    setTimer();
    //(*n_live_counter) = 0;
}
// ------------------------------------------------------------------------ //
void DaqMonitor::LoadMessageHandler(MessageHandler& msg)
{
    m_msg = &msg;
}
// ------------------------------------------------------------------------ //
void DaqMonitor::setTimer()
{
    std::stringstream sx;
    //if(dbg()) {
    //    sx << "DaqMonitor::setTimer()";
    //    msg()(sx,"DaqMonitor::setTimer"); sx.str("");
    //}
    if(m_timer) delete m_timer;

    m_timer = new QTimer();
    connect(m_timer, SIGNAL(timeout()), this, SLOT(checkCount()));
}
// ------------------------------------------------------------------------ //
void DaqMonitor::setCounter(int& counter)
//void DaqMonitor::setCounter(boost::shared_ptr< int > counter)
{
    n_live_counter = counter;
}
// ------------------------------------------------------------------------ //
void DaqMonitor::startTimer()
{
    if(dbg()) {
        msg()("Timer started...", "DaqMonitor::startTimer");
    }
    if(!m_timer) {
        setTimer();
    }
    if(!m_timer->isActive()) {
        m_timer->start(n_interval_to_check*1000); // timer is in milliseconds
    }
    m_is_monitoring = true;
}
// ------------------------------------------------------------------------ //
void DaqMonitor::closeMonitor()
{
    if(m_timer) {
        m_timer->stop();
    }
    m_is_monitoring = false;
}
// ------------------------------------------------------------------------ //
void DaqMonitor::stopTimer()
{
    if(dbg()) {
        msg()("Stopping timer...", "DaqMonitor::stopTimer");
    }
    if(!m_timer) {
        msg()("Timer is null!","DaqMonitor::stopTimer");
    }
    else {
        m_timer->stop();
    }
    m_is_monitoring = false;
}
// ------------------------------------------------------------------------ //
void DaqMonitor::checkCount()
{
    if(!m_is_monitoring) return;
    int count_to_check = n_live_counter;

    if(count_to_check == n_previous_counter)
        n_stuck_count++;
    else
        n_stuck_count = 0;

    if(n_stuck_count>=2) {
        std::cout << "DaqMonitor::checkCount [" << QThread::currentThreadId()
                << "]   DAQ HANG OBSERVED  is mon: " << m_is_monitoring  << std::endl;

        emit daqHangObserved();
    }
    //else if(n_stuck_count>=10) {
    //    std::cout << "DaqMonitor ---->> TOGGLE CALIBRATIONSOCKET" << std::endl;
    //    emit toggleCalibrationSocket();
    //    emit daqHangObserved();
    //}
    n_previous_counter = count_to_check;
}
