#include "calibration_type.h"

using std::string;

std::string CalibrationType2Str(const CalibrationType &c)
{
    string s = "Unknown";
    switch(c) {
        case CalibrationType::GlobalTestPulseDAC        : s = "GlobalTestPulseDAC"    ; break;
        case CalibrationType::GlobalThresholdDAC        : s = "GlobalThresholdDAC"    ; break;
        case CalibrationType::ChannelTrim               : s = "ChannelTrim"           ; break;
        case CalibrationType::ChannelBaseline           : s = "ChannelBaseline"       ; break;
        case CalibrationType::BaselineNeighbor          : s = "BaselineNeighbor"      ; break;
        case CalibrationType::BaselineExtrapolation     : s = "BaselineExtrapolation" ; break;
        case CalibrationType::Time                      : s = "Time"                  ; break;
        case CalibrationType::Custom                    : s = "Custom"                ; break;
        case CalibrationType::Efficiency                : s = "Efficiency"            ; break;
        case CalibrationType::Invalid                   : s = "Invalid"               ; break;
    } // end switch
    return s;
}

int CalibrationType2Int(const CalibrationType &c)
{
    int out = -1;
    switch(c) {
        case CalibrationType::GlobalTestPulseDAC        : out = 0;          ; break;
        case CalibrationType::GlobalThresholdDAC        : out = 1;          ; break;
        case CalibrationType::ChannelTrim               : out = 2;          ; break;
        case CalibrationType::ChannelBaseline           : out = 3;          ; break;
        case CalibrationType::BaselineNeighbor          : out = 4;          ; break;
        case CalibrationType::BaselineExtrapolation     : out = 5;          ; break;
        case CalibrationType::Time                      : out = 6;          ; break;
        case CalibrationType::Custom                    : out = 7;          ; break;
        case CalibrationType::Efficiency                : out = 8;          ; break;
        case CalibrationType::Invalid                   : out = -1;         ; break;
    }
    return out;
}

CalibrationType CalibrationTypeFromInt(const int &c)
{
    CalibrationType out = CalibrationType::Invalid;
    switch(c) {
        case(0)             : out = CalibrationType::GlobalTestPulseDAC     ; break;
        case(1)             : out = CalibrationType::GlobalThresholdDAC     ; break;
        case(2)             : out = CalibrationType::ChannelTrim            ; break;
        case(3)             : out = CalibrationType::ChannelBaseline        ; break;
        case(4)             : out = CalibrationType::BaselineNeighbor       ; break;
        case(5)             : out = CalibrationType::BaselineExtrapolation  ; break;
        case(6)             : out = CalibrationType::Time                   ; break;
        case(7)             : out = CalibrationType::Custom                 ; break;
        case(8)             : out = CalibrationType::Efficiency             ; break;
    }
    return out;
}
