#include "s6_setting.h"

#include <iostream>
#include <string>
#include <sstream>
using namespace std;


const QStringList s6Setting::all_CKTK
    = {"0", "12.5", "25"}; // ns
const QStringList s6Setting::all_CKBC
    = {"160", "160inv", "80", "40", "20", "10", "5", "2.5"}; // MHz
const QStringList s6Setting::all_CKBC_SKEW
    = {"0", "6.26", "12.52", "18.78"}; // ns

//////////////////////////////////////////////////////////////////////////////
// ------------------------------------------------------------------------ //
//  S6 settings
// ------------------------------------------------------------------------ //
//////////////////////////////////////////////////////////////////////////////
s6Setting::s6Setting() :
    cktk(0), // 0ns
    ckbc(2), // 80 MHz
    ckbc_skew(0), // 0 ns
    do_auto_reset(1),
    do_fec_reset(1),
    tk_pulses(2),
    fec_reset_period(4094),
    ok(false)
{
}
void s6Setting::print()
{
    stringstream ss;
    ss << "s6 settings " << endl;
    ss << "    > CKTK                  : " << s6Setting::all_CKTK[cktk].toStdString() << " ns" << endl;
    ss << "    > CKBC                  : " << s6Setting::all_CKBC[ckbc].toStdString() << " MHz" << endl;
    ss << "    > CKBC skew             : " << s6Setting::all_CKBC_SKEW[ckbc_skew].toStdString() << " ns" << endl;
    ss << "    > do vmm auto reset     : " << (do_auto_reset==1 ? "on" : "off") << endl;
    ss << "    > do FEC periodic reset : " << (do_fec_reset==1 ? "on" : "off") << endl;
    ss << "    > TK pulses for FEC reset : " << tk_pulses << endl;
    ss << "    > FEC reset period      : " << fec_reset_period << endl;
    cout << ss.str() << endl;
}
