#include "descriptor_channel.h"

//std/stl
#include <sstream>
#include <iostream>
#include <string>
using namespace std;

//boost
#include <boost/algorithm/string.hpp>

namespace fine {

DescriptorChannel::DescriptorChannel() :
    m_description_string(""),
    m_board_id(-1),
    m_vmm_id(-1)
{
}

void DescriptorChannel::set_description(string description_string)
{
    stringstream sx;

    m_description_string = description_string;
    vector<string> valid_descriptors = { "SM", "ST", "SD", "SC", "STH", "SL", "SMX", "SZ10", "SZ8", "SZ6" };

    vector<string> subs;
    boost::split(subs, description_string, boost::is_any_of(" "));

    for(auto sub : subs) {
        if(std::find(valid_descriptors.begin(), valid_descriptors.end(), sub)==valid_descriptors.end()) {
            sx << "DescriptorChannel::set_description    ERROR Invalid channel bit descrioption " << sub;
            throw std::runtime_error(sx.str());
        }
    }

    m_description_map.clear();
    for(int i = 0; i < (int)subs.size(); i++) {
        m_description_map[subs.at(i)] = i;
    }
}

bool DescriptorChannel::tree_has_board_id(int id)
{
    string test = "";
    stringstream node;
    node << "vmm_channel_config.board_id";
    try {
        test = tree().get<string>(node.str());
    }
    catch(std::exception& e) {
        cout << "DescriptorChannel::tree_has_board_id    ERROR Could not find the board id correctly: " << e.what() << endl;
        return false;
    }
    stringstream in;
    in << id;
    if(test == in.str())
        return true;
    else
        return false;
}

bool DescriptorChannel::tree_has_vmm_id(int id)
{
    string test = "";
    stringstream node;
    node << "vmm_channel_config.vmm_id";
    try {
        test = tree().get<string>(node.str());
    }
    catch(std::exception& e) {
        cout << "DescriptorChannel::tree_has_vmm_id    ERROR Could not find the vmm id correctly: " << e.what() << endl;
        return false;
    }
    stringstream in;
    in << id;
    if(test == in.str())
        return true;
    else
        return false;
}

bool DescriptorChannel::channel_register(int channel_number, string name, string & value)
{
    stringstream node;
    node << "vmm_channel_config.configuration." << channel_number;
    string node_string = "";
    try {
        node_string = tree().get<string>(node.str());
    }
    catch(std::exception& e) {
        cout << "DescriptorChannel::channel_register    ERROR Could not find the value for channel register " << name << " for channel " << channel_number << ": " << e.what() << endl;
        value = "";
        return false;
    }
    vector<string> split_values;
    boost::split(split_values, node_string, boost::is_any_of(" "));

    int idx_of_register = desc_idx_map()[name];

    try {
        value = split_values.at(idx_of_register);
    }
    catch(std::exception& e) {
        cout << "DescriptorChannel::channel_register    ERROR Could not obtain value from channel register string for register " << name << " and channel " << channel_number << ": " << e.what() << endl;
        value = "";
        return false;
    }
    return true;
}


} // namespace fine
