import sys, os
from pathlib import Path
import visa
import pyvisa
import time
import re
import sys


class controlRobot():

    def __init__(self) :
        self.connected=True
        self._emulate=False
        self._my_instrument = pyvisa.resources.gpib.GPIBInstrument


    def Connect(self) :
        if (self._emulate is True):
            rm = visa.ResourceManager('@sim')
            print("Simulation mode")
            print(rm.list_resources('?*'))
            my_instrument=rm.open_resource('ASRL1::INSTR', read_termination='\n')
            print(my_instrument.query("?IDN"))
        else:
            rm = visa.ResourceManager()
            #print(rm.list_resources('?*')) ##lists everything
            connectedInstrument = rm.list_resources('?*')
            trGPIBIdentifier = "GPIB0::1::INSTR"
            if trGPIBIdentifier in connectedInstrument:
                self._my_instrument=rm.open_resource(trGPIBIdentifier, read_termination='\r\n')
                identity = self._my_instrument.query('ID?')
                print("connecting to " +identity)
            else:
                print("connecting to handler failed")
                return 0
        return 1
        #self.connected
        

    def DeviceReady(self):
        rep = 0
        msg = 'Y'
        if(self._emulate is True):
            #print "    (emulate mode: press enter for device ready)"
            rep = "9"
            time.sleep(0.1)
        else:
            rep = self._my_instrument.query("SQB?")
            print("Handler response: "+str(rep))
        if  (rep == 'y'): rep = "1"
        elif(rep == 'n'): rep = "0"
        elif(rep == 'm'): rep = "aaa"
        elif(rep == 'x' or rep == 'X'):
            return "X"
                
        if rep == False:
            print("**------------------ The GPIB Device didn't send a reply within the timeout period")
            return False
        elif rep == "1":
            print ("**------------------ Test system ready to proceed to next chip")
            return True
        elif rep == "0":
            return False
        elif rep == "9":
            print ("**------------------ In Emulation mode")
            return True
        else:
            print("**------------------ received unexpected reply from handler :  " + str(rep))
            return False

    def SendToBin(self, BIN):
        if(self._emulate is True):
            print("**------------------ Sorting in emulation mode: ")
            return str(BIN)
        else:
            rep = self._my_instrument.write("A BIN " + str(BIN))
            return rep
