#!/usr/bin/env python3
import sys, os
from pathlib import Path
import visa
import pyvisa
import time
import re
import sys
# Logger
import spdlog
import unittest
from spdlog import ConsoleLogger, FileLogger, RotatingLogger, DailyLogger, LogLevel

class controlPS() :

    def __init__(self) :
        self.connected = True
        self.name = "xx"
        self._emulate = False
        self._my_instrument = pyvisa.resources.gpib.GPIBInstrument
        self.logger = ConsoleLogger('Power Supply', True, True, True)

    def Status(self) :
        rm = visa.ResourceManager()
        #print(rm.list_resources('?*')) ##lists everything
        print(rm.list_resources('?*'))
        
    def Connect(self) :
        if self._emulate:
            rm = visa.ResourceManager('@sim')
            print("Simulation mode")
            print(rm.list_resources('?*'))
            my_instrument=rm.open_resource('ASRL1::INSTR', read_termination='\n')
            print(my_instrument.query("?IDN"))
        else:
            rm = visa.ResourceManager()
            #print(rm.list_resources('?*')) ##lists everything
            connectedInstrument = rm.list_resources('?*')
            psGPIBIdentifier = "GPIB1::1::INSTR"
            if psGPIBIdentifier in connectedInstrument:
                self._my_instrument=rm.open_resource(psGPIBIdentifier, read_termination='\n')
                identity = self._my_instrument.query('*IDN?')
                if("THURLBY-THANDAR,TSX3510P,0,1.20" in identity):
                    print("connecting to " +identity)
                    #self.connected = True
                else:
                    print("Power supply not correctly identified")
                    #self.connected = False
            else:
                print("GPIB Supply cannot be found")
                #self.connected = False
            
        return 1
        #self.connected

    def Close(self):
        self._my_instrument.close()
        #self.connected = False
        
    def isConnected(self):
        return self.connected
    
    def readVoltage(self):
        voltageReadout = self._my_instrument.query('VO?')
        newstr = ''.join((ch if ch in '0123456789.-e' else ' ') for ch in voltageReadout)
        listOfNumbers = [float(i) for i in newstr.split()]
        voltage = float(listOfNumbers[0])
        return voltage
    
    def readCurrent(self):
        currentReadout = self._my_instrument.query('IO?')
        newstr = ''.join((ch if ch in '0123456789.-e' else ' ') for ch in currentReadout)
        listOfNumbers = [float(i) for i in newstr.split()]
        current = float(listOfNumbers[0])
        return current
    
    
    def switchPSOn(self):
        state = self._my_instrument.write('OP 1')
        return True;
        
    def switchPSOff(self):
        state = self._my_instrument.write('OP 0')
        return True;
#
#
#
#print(my_instrument.query('*IDN?'))
#
#voltage = my_instrument.query('VO?')
#current = my_instrument.query('IO?')
#
#print(voltage)
#print(current)
#
#newstr = ''.join((ch if ch in '0123456789.-e' else ' ') for ch in current)
#listOfNumbers = [float(i) for i in newstr.split()]
#instantCurrent = float(listOfNumbers[0])
#
#print(instantCurrent)
#if current <=1:
#print("off")


#my_instrument.close()

#my_instrument.write("*rst; status:preset; *cls")
#my_instrument.write('V 5.00')
#my_instrument.write('I 2.00')
#my_instrument.read_termination = '\n'
#my_instrument.write_termination = '\n'
#my_instrument.query('*IDN?')
