#
# project file for vmmdcs
#
# daniel.joseph.antrim@cern.ch
# July 2016
#

#####################################################
# directory and machine specific items here
#####################################################
linebreak="---------------------------------------------------------------"

# for now, the user specifies where Boost is located
boostinclude=.
boostlib=.


# do not touch these
sourcepath=../src
includepath=../include
imagepath=../images

message($$linebreak)
message("qmake sourcepath:      $$sourcepath")
message("qmake includepath:     $$includepath")
message("qmake boostinclude:    $$boostinclude")
message("qmake boostlib:        $$boostlib")
message("qmake imagepath:       $$imagepath")
message("ROOTSYS:               $(ROOTSYS)")
message($$linebreak)

#####################################################

QT      += core gui
QT      += network
QT      += widgets
QT      += xml
greaterThan(QT_MAJOR_VERSION, 4): QT += printsupport
CONFIG  += console
CONFIG  +=declarative_debug
CONFIG  +=c++11

#TARGET   = vmmdcs
TARGET   = verso
TEMPLATE = app

# make sure the boost version we point to is this one
DEFINES += BOOST_ALL_NO_LIB

linux {
	QMAKE_RPATHDIR += $$boostlib
	QMAKE_RPATHDIR += ./objects
}

INCLUDEPATH += $(ROOTSYS)/include
win32:LIBS += -L$(ROOTSYS)/lib -llibCint -llibRIO -llibNet \
       -llibHist -llibGraf -llibGraf3d -llibGpad -llibTree \
       -llibRint -llibPostscript -llibMatrix -llibPhysics \
       -llibGui -llibRGL -llibMathCore
else:LIBS += -L$(ROOTSYS)/lib -lCore -lCint -lRIO -lNet \
       -lHist -lGraf -lGraf3d -lGpad -lTree \
       -lRint -lPostscript -lMatrix -lPhysics \
       -lGui -lMathCore #-lRGL -lMathCore

LIBS +=  -L$$boostlib -lboost_thread -lboost_filesystem  -lboost_system -lboost_chrono -lboost_atomic
# LIBS +=  -L$$boostlib -lboost_thread-mt -lboost_filesystem-mt  -lboost_system-mt -lboost_chrono-mt -lboost_atomic-mt

LIBS += -L./objects -lMylib

INCLUDEPATH += $$includepath
DEPENDPATH  += $$includepath
INCLUDEPATH += $$includepath/mapping/
DEPENDPATH  += $$includepath/mapping/
INCLUDEPATH += $$includepath/monitoring/
DEPENDPATH  += $$includepath/monitoring/
INCLUDEPATH += $$includepath/configuration/
DEPENDPATH  += $$includepath/configuration/
INCLUDEPATH += $$includepath/dataflow/
DEPENDPATH  += $$includepath/dataflow/
INCLUDEPATH += $$boostinclude
DEPENDPATH  += $$boostinclude

OBJECTS_DIR += ./objects/
MOC_DIR     += ./moc/
RCC_DIR     += ./rcc/
UI_DIR      += ./ui/

SOURCES += $$sourcepath/main.cpp\
           $$sourcepath/mainwindow.cpp\
           #dataflow
           $$sourcepath/dataflow/dataflowwindow.cpp\
           $$sourcepath/dataflow/qcustomplot.cpp\
           $$sourcepath/run_module.cpp\
           $$sourcepath/config_handler.cpp\
           ## configuration
           $$sourcepath/configuration/comm_info.cpp\
           $$sourcepath/configuration/trigger_daq.cpp\
           $$sourcepath/configuration/global_setting.cpp\
           $$sourcepath/configuration/vmm_map.cpp\
           $$sourcepath/configuration/channel.cpp\
           $$sourcepath/configuration/fpga_clocks.cpp\
           $$sourcepath/configuration_module.cpp\
           $$sourcepath/socket_handler.cpp\
           $$sourcepath/vmmsocket.cpp\
           $$sourcepath/calibration_module.cpp\
           $$sourcepath/calibration_type.cpp\
           $$sourcepath/pulser_calibration.cpp\
           $$sourcepath/message_handler.cpp\
           $$sourcepath/daq_server.cpp\
           $$sourcepath/data_handler.cpp\
           $$sourcepath/event_builder.cpp\
           $$sourcepath/daq_monitor.cpp\
           ## mapping related below
           $$sourcepath/mapping/map_handler.cpp\
           $$sourcepath/mapping/daq_config.cpp\
           $$sourcepath/mapping/det_config.cpp\
           $$sourcepath/mapping/detector.cpp\
           $$sourcepath/mapping/module.cpp\
           $$sourcepath/mapping/layer.cpp\
           $$sourcepath/mapping/connector.cpp\
           $$sourcepath/mapping/board.cpp\
           $$sourcepath/mapping/chip.cpp\
           $$sourcepath/mapping/element.cpp\
           $$sourcepath/mapping/element_type.cpp\
           ## monitoring related below
           $$sourcepath/monitoring/OnlineMonTool.cpp\
           ## daq buffer
           $$sourcepath/daq_buffer.cpp\
           $$sourcepath/calibration_state.cpp\
           ## calibration loading
           $$sourcepath/calibration_threshold_loader.cpp\
           ## trigger event
           $$sourcepath/trigger_event.cpp\
           $$sourcepath/vmm_hit.cpp\
           ## raw data
           $$sourcepath/raw_data_dumper.cpp\
           ## data decoder
           $$sourcepath/vmm_decoder.cpp

HEADERS  += $$includepath/mainwindow.h\
            #dataflow
            $$includepath/dataflow/dataflowwindow.h\
            $$includepath/dataflow/qcustomplot.h\
            $$includepath/run_module.h\
            ## configuration
            $$includepath/configuration/comm_info.h\
            $$includepath/configuration/trigger_daq.h\
            $$includepath/configuration/global_setting.h\
            $$includepath/configuration/vmm_map.h\
            $$includepath/configuration/channel.h\
            $$includepath/configuration/fpga_clocks.h\
            $$includepath/config_handler.h\
            $$includepath/configuration_module.h\
            $$includepath/socket_handler.h\
            $$includepath/vmmsocket.h\
            $$includepath/calibration_module.h\
            $$includepath/calibration_type.h\
            $$includepath/pulser_calibration.h\
            $$includepath/message_handler.h\
            $$includepath/bit_manip.h\
            $$includepath/data_handler.h\
            $$includepath/daq_server.h\
            $$includepath/event_builder.h\
            $$includepath/daq_monitor.h\
            ## mapping related below
            $$includepath/mapping/map_handler.h\
            $$includepath/mapping/daq_config.h\
            $$includepath/mapping/det_config.h\
            $$includepath/mapping/detector.h\
            $$includepath/mapping/module.h\
            $$includepath/mapping/layer.h\
            $$includepath/mapping/connector.h\
            $$includepath/mapping/board.h\
            $$includepath/mapping/chip.h\
            $$includepath/mapping/element.h\
            $$includepath/mapping/element_type.h\
            ## monitoring related below
            $$includepath/monitoring/OnlineMonTool.h\
            ## daq buffer
            $$includepath/readerwriterqueue.h\
            $$includepath/atomicops.h\
            $$includepath/daq_buffer.h\
            $$includepath/data_array_types.h\
            $$includepath/calibration_state.h\
            $$includepath/calibration_threshold_loader.h\
            # trigger event
            $$includepath/trigger_event.h\
            $$includepath/vmm_hit.h\
            # raw data
            $$includepath/raw_data_dumper.h\
            # data decoder
            $$includepath/vmm_decoder.h

FORMS    += $$sourcepath/mainwindow.ui \
            $$sourcepath/dataflow/dataflowwindow.ui

RESOURCES += \
    $$imagepath/icons.qrc
