#ifndef CALIBRATION_THRESHOLD_LOADER_H
#define CALIBRATION_THRESHOLD_LOADER_H

//////////////////////////////////////////////////
//
// calibration_threshold_loader
//
// Tool to load the calibration files for the
// VMM thresholds.
//
// Holds the values and also provides them to
// the interface upon request
//
// daniel.joseph.antrim@cern.ch
// March 2017
//
//////////////////////////////////////////////////

// boost
#include <boost/property_tree/ptree.hpp>

// std/stl
#include <vector>
#include <map>
#include <string>

struct ThresholdHolder {

    std::string board_ip;
    int board_id;
    int chip_id;
    int channel;
    int trim_to_set;

}; // ThresholdHolder

typedef std::map<int, std::vector<ThresholdHolder> > BoardIdDataHolder;
typedef std::map<std::string, std::vector<ThresholdHolder> > BoardIpDataHolder;


class CalibrationThresholdLoader {

    public :
        CalibrationThresholdLoader();
        virtual ~CalibrationThresholdLoader();

        void clear();
        void clear_current();

        bool load_file(std::string calib_file_to_load);
        bool load_board(const boost::property_tree::ptree::value_type node);
        bool load_chip(const boost::property_tree::ptree::value_type node);
        bool load_trim(const boost::property_tree::ptree::value_type node);

        void sort_data();

        bool thresholds_loaded();

        int trim_value(std::string ip, int chip, int channel);

        std::string summary_table();

        std::vector<ThresholdHolder> thresholds_for_board(std::string ip_of_board);
        bool is_valid_ip(std::string ip_to_check);
        //std::vector<ThresholdHolder> thresholds_for_board(int id_of_board);

    private :
        std::string m_filename;
        std::string m_current_board_ip;
        int m_current_board_id;
        int m_current_chip_id;
        int m_current_channel;
        int m_current_trim;

        bool m_thresholds_loaded;

        std::vector<ThresholdHolder> m_holder;
        std::vector<std::string> m_unique_ips;
        std::vector<int> m_unique_ids;
        BoardIpDataHolder m_ip_holder;
        BoardIdDataHolder m_id_holder;

}; // class CalibrationThresholdLoader

#endif
