#ifndef CALIBRATION_TYPE_H
#define CALIBRATION_TYPE_H

#include <string>

enum CalibrationType {
    GlobalTestPulseDAC=0,
    GlobalThresholdDAC,
    ChannelTrim,
    ChannelBaseline,
    BaselineNeighbor,
    BaselineExtrapolation,
    Time,
    Custom,
    Efficiency,
    AnalogPulse,
    Invalid
};

/// Human-readable names
std::string CalibrationType2Str(const CalibrationType &c);
int CalibrationType2Int(const CalibrationType &c);
CalibrationType CalibrationTypeFromInt(const int &c);


#endif
