#ifndef FINE_CONFIGURATION_MODULE_H
#define FINE_CONFIGURATION_MODULE_H

// std/stl
#include <string>
#include <vector>

// fine_configuration_module
#include "descriptor_channel.h"
#include "descriptor_global.h"
#include "descriptor_common.h"

// vmm
#include "message_handler.h"

// Qt

//boost
#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/property_tree/json_parser.hpp>

class FineConfigurationModule : public QObject
{

    Q_OBJECT

    struct FineHolder {
        FineHolder() :
            board_id(-1),
            board_ip("")
        {}
        FineHolder(int id, std::string ip) :
            board_id(id),
            board_ip(ip) {}

        void clear() { board_id = -1; board_ip = -1; descriptors.clear(); }

        int board_id;
        std::string board_ip;
        std::vector<fine::DescriptorBase*> descriptors;
    };

    public :

        explicit FineConfigurationModule(QObject* parent = 0);
        virtual ~FineConfigurationModule(){};

        void setDebug(bool dbg) { m_dbg = dbg; }
        bool dbg() { return m_dbg; }

        void LoadMessageHandler(MessageHandler& msg);
        MessageHandler& msg() { return *m_msg; }

        bool has_ip(std::string ipstring);

        bool load_fine_configuration_file(std::string filename = "");
        bool load_description(std::string filename = "");
        void parse_description(boost::property_tree::ptree ptree);

        void load_board(const boost::property_tree::ptree ptree, int id = -1);
//        void load_board(const boost::property_tree::ptree::value_type pt);

        // description
        std::string description_name() { return m_description_name; }
        std::vector<fine::DescriptorBase*>& descriptors() { return m_descriptors; }

        std::vector<fine::DescriptorBase*> descriptors_of_type(std::string type = "");
        std::vector<fine::DescriptorBase*> descriptors_of_type_for_board_ip(std::string type = "", std::string ip = "");
        std::vector<fine::DescriptorBase*> descriptors_for_board_id(int board_id = -1);
        std::vector<fine::DescriptorBase*> common_descriptor_for_board_id(int board_id = -1);
        std::vector<fine::DescriptorBase*> common_descriptor_for_board_ip(std::string board_ip = "");
        std::vector<fine::DescriptorBase*> descriptors_for_board_ip(std::string board_ip = "");
        std::vector<fine::DescriptorBase*> descriptor_for_board_and_vmm(int board_id = -1, int vmm_id = -1);
        std::vector<fine::DescriptorBase*> descriptor_for_board_and_vmm(std::string board_ip = "", int vmm_id = -1);

        std::vector<fine::DescriptorBase*> descriptors_for_vmmid(int id, std::vector<fine::DescriptorBase*> descriptors);
        


    private :
        bool m_dbg;
        MessageHandler* m_msg;
        std::string m_description_file;

        // description
        std::string m_description_name;

        std::vector<FineHolder> m_holders;
        std::vector<fine::DescriptorBase*> m_descriptors;

}; // class FineConfigurationModule


#endif
