#ifndef RUN_MODULE_H
#define RUN_MODULE_H

/////////////////////////////////////////
//
// run_module
//
// Tool for building and sending the
// ACQ on/off commands, FPGA configuration,
// run modes, TDAQ configuration, etc...
//
//  - i.e. communication between the GUI
//          and the front-end not related to
//          the global SPI/VMM configuration
//
// daniel.joseph.antrim@cern.ch
// March 2016
//
//////////////////////////////////////////

// vmm
#include "socket_handler.h"
#include "config_handler.h"
#include "message_handler.h"

// qt
#include <QObject>

class RunModule : public QObject
{
    Q_OBJECT

    public :
        explicit RunModule(QObject *parent = 0);
        virtual ~RunModule(){};
        RunModule& setDebug(bool dbg) { m_dbg = dbg; return *this; }
        bool dbg() { return m_dbg; }

        void set_vmm_type(int type) { m_vmm_type = type; }
        int vmm_type() { return m_vmm_type; }

        void LoadMessageHandler(MessageHandler& msg);
        MessageHandler& msg() { return *m_msg; }

        ////////////////////////////////////////////
        // Run toggles
        ////////////////////////////////////////////
        /**
         set flag for running with external or internal
         triggers
        */
        void setExternalTrig(bool doit) { m_externalTrigger = doit; }
        bool externalTrig() { return m_externalTrigger; }

        ///////////////////////////////////////////
        // VMM handles
        ///////////////////////////////////////////
        RunModule& LoadConfig(ConfigHandler& config);
        RunModule& LoadSocket(SocketHandler& socket);

        SocketHandler& socket() { return *m_socketHandler; }
        ConfigHandler& config() { return *m_configHandler; }

        ///////////////////////////////////////////
        // Methods for setting up T/DAQ
        // and sending the configuration
        ///////////////////////////////////////////
        void set_acquisition(int on_or_off);
        void set_acquisition_VMM2(int on_or_off);

        void set_trigger_settings();
        void setTriggerMode(bool enable_fixed_latency_run_mode=false);
        void send_tdaq_settings(int latency_steps, bool internal,
                    bool external, bool externalbc, int deadtime,
                    int n_ckbc_fixed_tac, int art_timeout,
                    int extra_ckbc_latency);
        void send_tdaq_settings_VMM2(bool internal, bool external);
        void ACQon();
        void ACQoff();

        ///////////////////////////////////////////
        // clocks
        ///////////////////////////////////////////
        void configure_clocks(int cktk_max, int ckbc_frequency, int n_tp_pulses,
                                    int tp_skew_steps, int tp_period, int tp_width);


        //////////////////////////////////////////////////////
        // Misc. methods
        //////////////////////////////////////////////////////
        //void setEventHeaders(const int evbld_info, const int evbld_mode, bool highRes=false);
        void resetASICs();
        //void resetFEC(bool do_reset);
        //void setMask();
        //void enableART(bool enabling, bool enableHoldOff);
        //void checkLinkStatus();
        //void resetLinks();
        //void s6clocks(int cktk, int ckbc, int ckbc_skew);
        //void setS6Resets(int s6_tk_pulses, bool set_s6_autoReset, bool set_s6_fecReset,
        //                        int s6_fec_periodReset);
        //void configTP(int tpskew, int tpwidth, int tppolarity);

    private :
        bool m_dbg;
        int m_vmm_type;
        MessageHandler *m_msg;
        bool m_externalTrigger;
        long int m_pulseCount; 
        bool m_initSocketHandler;
        bool m_initConfigHandler;

        SocketHandler *m_socketHandler;
        ConfigHandler *m_configHandler;

    signals :
        //void checkLinks();

    public slots :
        void resetFPGA();
        void set_acq_pulser(int);
        void set_clocks_pulser(int,int,int,int,int,int);
        void calib_configuration_update(int,int);

}; // class RunModule

#endif
