#include <QApplication>
#include <QStyleFactory>
#include "mainwindow.h"
#include <string>
#include <iostream>
using namespace std;

string version = "v4.4.0";

void help()
{
    cout << "--------------------------------------------------------------" << endl;
    cout << "                       V.E.R.S.O.!                            " << endl;
    cout << "            (Vmm Ethernet Readout SOftware)                   " << endl;
    cout << "                        ("<<version<<")                              " << endl;
    cout << " - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" << endl;
    cout << endl;
    cout << " Usage: ./verso [options]" << endl;
    cout << endl;
    cout << " Options:" << endl;
    cout << "  -v|--vmm         vmm type ('2' or '3', default: '3') [OPTIONAL]" << endl;
    cout << "  --config         name (path to) configuration XML file to" << endl;
    cout << "                   load upon start-up [OPTIONAL]" << endl;
    cout << "  --daq-config     name (path to) detector setup XML file to" << endl;
    cout << "                   load upon start-up [OPTIONAL]" << endl;
    cout << "  --channel-trims  name (path to) channel threshold trim calibration" << endl;
    cout << "                   XML file to load upon start-up [OPTIONAL]" << endl;
    cout << "  --outdir         name (path to) output directory to place" << endl;
    cout << "                   output data files [OPTIONAL] [DIR MUST EXIST]" << endl;
    cout << "                   (default: ${HOME})" << endl;
    cout << "  --n-vmm          number of VMMs connected per FEB [OPTIONAL] (default: 1)" << endl;
    cout << "  --n-feb          number of FEBs connected [OPTIONAL] (default: 1)" << endl;
    cout << "  --base-ip        base IP (4th component of IPv4 address of " << endl;
    cout << "                   the first FEB) [OPTIONAL] (default: 16)" << endl;
    cout << "  -h|--help        print this help message" << endl;
    cout << endl;
    cout << "--------------------------------------------------------------" << endl;
    cout << " Contacts: " << endl;
    cout << "   Daniel Joseph Antrim, University of California, Irvine" << endl;
    cout << "    daniel.joseph.antrim@cern.ch" << endl;
    cout << "   George Iakovidis, Brookhaven National Lab" << endl;
    cout << "    george.iakovidis@cern.ch" << endl;
    cout << "--------------------------------------------------------------" << endl;
    return;
}

int main(int argc, char *argv[])
{
    QFont Font;
    Font.setFamily("Arial");
    Font.setPixelSize(10);
    QApplication::setFont(Font);

    ///////////////////////////////////////
    // command line arguments
    ///////////////////////////////////////
    int vmm_type = 3;
    string input_configuration_file = "";
    string input_daq_config_file = "";
    string output_directory = "";
    string channel_trims_file = "";
    int n_feb = 0;
    int n_vmm = 0;
    int base_ip = 0;
    int optin(1);
    while(optin < argc) {
        string in = argv[optin];
        if      (in == "-v" || in == "--vmm")   { vmm_type = atoi(argv[++optin]); }
        else if (in == "--config")              { input_configuration_file = argv[++optin]; }
        else if (in == "--daq-config")          { input_daq_config_file = argv[++optin]; }
        else if (in == "--outdir")              { output_directory = argv[++optin]; } 
        else if (in == "--channel-trims")       { channel_trims_file = argv[++optin]; }
        else if (in == "--n-vmm")               { n_vmm = atoi(argv[++optin]); }
        else if (in == "--n-feb")               { n_feb = atoi(argv[++optin]); }
        else if (in == "--base-ip")             { base_ip = atoi(argv[++optin]); }
        else if (in == "-h" || in == "--help")  { help(); return 0; }
        else {
            cout << "VERSO    Unknown command line argument provided: '" << in << "', exiting" << endl;
            help();
            return 1;
        }
        optin++;
    } // while

    cout << "--------------------------------------------------------------" << endl;
    cout << "                       V.E.R.S.O.!                            " << endl;
    cout << "            (Vmm Ethernet Readout SOftware)                   " << endl;
    cout << "                        ("<<version<<")                              " << endl;
    cout << " - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" << endl;
    cout << " Provided run options: " << endl;
    cout << endl;
    cout << " - vmm type                    : " << vmm_type << endl;
    cout << " - input configuration XML     : " << (input_configuration_file=="" ? "-" : input_configuration_file) << endl;
    cout << " - input detector config XML   : " << (input_daq_config_file=="" ? "-" : input_daq_config_file) << endl;
    cout << " - output directory            : " << (output_directory=="" ? "${HOME}" : output_directory) << endl;
    cout << " - channel trims XML           : " << (channel_trims_file=="" ? "-" : channel_trims_file) << endl;
    cout << " - number of FEBs              : " << ((n_feb > 0) ? n_feb : 1) << endl;
    cout << " - number of VMMs per FEB      : " << ((n_vmm > 0) ? n_vmm : 1) << endl;
    cout << " - base IP address             : " << ((base_ip > 0) ? base_ip : 16) << endl; 
    cout << " - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -" << endl;
    cout << " Contacts: " << endl;
    cout << "   Daniel Joseph Antrim, University of California, Irvine" << endl;
    cout << "    daniel.joseph.antrim@cern.ch" << endl;
    cout << "   George Iakovidis, Brookhaven National Lab" << endl;
    cout << "    george.iakovidis@cern.ch" << endl;
    cout << "--------------------------------------------------------------" << endl;

    QApplication a(argc, argv);
    // make appearance same between linux and mac
    a.setStyle(QStyleFactory::create("Fusion"));
    MainWindow w;
    stringstream window_title;
    window_title << "VERSO - " << version;
    w.setWindowTitle(QString::fromStdString(window_title.str()));
    //w.setWindowTitle("VERSO - v4.2.1");

    // load the cmd line stuff
    if(!(vmm_type == 2 || vmm_type == 3)) {
        cout << "ERROR You have provided an invalid vmm type '" << vmm_type << "', only accept '2' or '3'" << endl;
    }
    w.load_cmdline_vmm_type(vmm_type);
    if(input_configuration_file != "") {
        w.load_cmdline_config_xml(input_configuration_file);
    }
    if(input_daq_config_file != "") {
        w.load_cmdline_daq_config_xml(input_daq_config_file);
    }
    if(channel_trims_file != "") {
        w.load_cmdline_channel_trims_xml(channel_trims_file);
    }
    if(output_directory != "") {
        w.load_cmdline_output_directory(output_directory);
    }
    if( (n_feb>0) || (n_vmm>0) || (base_ip>0) ) {
        w.load_cmdline_comms(n_feb, n_vmm, base_ip);
    }

    // open up the UI
    w.show();
    
    return a.exec();
}
