#ifndef FINE_CONFIGURATION_DESCRIPTOR_BASE_H
#define FINE_CONFIGURATION_DESCRIPTOR_BASE_H


//fine

//std/stl
#include <string>


//boost
#include <boost/property_tree/json_parser.hpp>

namespace fine {

class DescriptorBase {

    public :
        DescriptorBase() :
            m_type(""),
            m_vmm_id(-1)
            {};
        virtual ~DescriptorBase(){};

        void set_type(std::string type) { m_type = type; }
        std::string type() { return m_type; }

        virtual void set_vmm_id(int id) { m_vmm_id = id; }
        virtual int vmm_id() { return m_vmm_id; }

        void set_tree(boost::property_tree::ptree tree) { m_ptree = tree; }
        boost::property_tree::ptree& tree() { return m_ptree; }


    protected :
        std::string m_type;
        boost::property_tree::ptree m_ptree;

        int m_vmm_id;

    

}; // class DescriptorBase


} // namespace fine

#endif
