#include "fine_configuration_module.h"


//std/stl
#include <iostream>
#include <fstream>
using namespace std;

//fine

//vmm

//boost
#include <boost/algorithm/string.hpp>


//Qt



FineConfigurationModule::FineConfigurationModule(QObject* parent) :
    QObject(parent),
    m_dbg(false),
    m_msg(nullptr)
{
    cout << "FineConfigurationModule::FineConfigurationModule    hello!" << endl;
}

void FineConfigurationModule::LoadMessageHandler(MessageHandler& msg)
{
    m_msg = &msg;
}

bool FineConfigurationModule::has_ip(string ipstring)
{
    for(auto holder : m_holders) {
        if(holder.board_ip == ipstring) {
            auto common = common_descriptor_for_board_ip(ipstring);
            if(common.size() == 0)
                return false;
            else
                return true;
        }
    } // holder
    return false;
}

vector<fine::DescriptorBase*> FineConfigurationModule::descriptors_of_type(string type)
{
    vector<fine::DescriptorBase*> out;
    for(auto & desc : m_descriptors) {
        if(desc->type() == type) out.push_back(desc);
    }
    return out;
}

vector<fine::DescriptorBase*> FineConfigurationModule::descriptors_of_type_for_board_ip(string type, string ip)
{
    vector<fine::DescriptorBase*> out;
    for(auto holder : m_holders) {
        if(holder.board_ip == ip) {
            for(auto & desc : holder.descriptors) {
                if(desc->type() == type) out.push_back(desc);
            }
        }
    }
    return out;
}

vector<fine::DescriptorBase*> FineConfigurationModule::descriptors_for_board_id(int board_id)
{
    vector<fine::DescriptorBase*> out;
    for(auto holder : m_holders) {
        if(holder.board_id == board_id) return holder.descriptors;
    }
    return out;
}

vector<fine::DescriptorBase*> FineConfigurationModule::descriptors_for_board_ip(std::string ip)
{
    vector<fine::DescriptorBase*> out;
    for(auto holder : m_holders) {
        if(holder.board_ip == ip) return holder.descriptors;
    }
    return out;
}

vector<fine::DescriptorBase*> FineConfigurationModule::descriptor_for_board_and_vmm(int board_id, int vmm_id)
{
    vector<fine::DescriptorBase*> out;
    for(auto holder : m_holders) {
        if(holder.board_id != board_id) continue;
        for(auto & desc : holder.descriptors) {
            if(desc->type()!="COMMON") {
                if(desc->vmm_id() == vmm_id) out.push_back(desc);
            }
        }
    }
    return out;
}
vector<fine::DescriptorBase*> FineConfigurationModule::descriptor_for_board_and_vmm(string board_ip, int vmm_id)
{
    vector<fine::DescriptorBase*> out;
    for(auto holder : m_holders) {
        if(holder.board_ip != board_ip) continue;
        for(auto & desc : holder.descriptors) {
            if(desc->type()!="COMMON") {
                if(desc->vmm_id() == vmm_id) out.push_back(desc);
            }
        }
    }
    return out;
}

vector<fine::DescriptorBase*> FineConfigurationModule::common_descriptor_for_board_id(int board_id)
{
    vector<fine::DescriptorBase*> out;
    for(auto holder : m_holders) {
        if(holder.board_id != board_id) continue;
        for(auto & desc : holder.descriptors) {
            if(desc->type()=="COMMON") out.push_back(desc);
        }
    } // holder
    return out;
}
vector<fine::DescriptorBase*> FineConfigurationModule::common_descriptor_for_board_ip(string ip)
{
    vector<fine::DescriptorBase*> out;
    for(auto holder : m_holders) {
        if(holder.board_ip != ip) continue;
        for(auto & desc : holder.descriptors) {
            if(desc->type()=="COMMON") out.push_back(desc);
        }
    } // holder
    return out;
}

vector<fine::DescriptorBase*> FineConfigurationModule::descriptors_for_vmmid(int id, vector<fine::DescriptorBase*> descriptors)
{
    vector<fine::DescriptorBase*> out;
    for(auto & desc : descriptors) {
        if(desc->vmm_id() == id /* && desc.tree_has_vmm_id(id)*/) out.push_back(desc);
    }
    return out;
}

bool FineConfigurationModule::load_fine_configuration_file(string filename)
{
    stringstream sx;

    if(filename=="") {
        sx << "ERROR Fine configuration file is empty";
        msg()(sx.str(), "FineConfigurationModule::load_fine_configuration_file"); sx.str("");
        return false;
    }

    bool file_found = std::ifstream(filename).good();
    if(!file_found) {
        sx << "ERROR Fine configuration file (=" << filename << ") not found";
        msg()(sx.str(), "FineConfigurationModule::load_fine_configuration_file"); sx.str("");
        return false;
    }

    string filetype = filename.substr(filename.size() - 4);

    if(filetype != ".xml") {
        sx << "ERROR Fine configuration file must be XML format!";
        msg()(sx.str(), "FineConfigurationModule::load_fine_configuration_file"); sx.str("");
        return false;
    }

    m_description_file = filename;

    return load_description(filename);
}

bool FineConfigurationModule::load_description(string filename)
{
    stringstream sx;

    using boost::property_tree::ptree;
    using namespace boost::property_tree::xml_parser;
    ptree pt;

    try {
        read_xml(filename, pt, trim_whitespace  | no_comments);
    }
    catch(std::exception& e) {
        sx << "ERROR Unable to parse fine description file: " << e.what();
        msg()(sx.str(), "FineConfigurationModule::load_description"); sx.str("");
        return false;
    }

    try {
        parse_description(pt);
    }
    catch(std::exception& e) {
        sx << "ERROR Unable to walk through description XML file: " << e.what();
        msg()(sx.str(), "FineConfigurationModule::load_description"); sx.str("");
        return false;
    }
    return true;
}

void FineConfigurationModule::parse_description(boost::property_tree::ptree pt)
{
    string fn = "FineConfigurationModule::parse_description    ";
    cout << fn << endl;
    using boost::property_tree::ptree;
    using namespace boost;

    m_descriptors.clear();
    m_holders.clear();

    for(const auto& p : pt.get_child("fine_configuration")) {
        if(p.first == "name") {
            m_description_name = p.second.data();
            boost::trim(m_description_name);
        }
        else if(p.first == "board") {
            int id = std::stoi(p.second.get<string>("<xmlattr>.id"));
            load_board(p.second, id);
        }

    } // p
}

void FineConfigurationModule::load_board(const boost::property_tree::ptree pt, int id)
{
    string fn = "FineConfigurationModule::load_board    ";

    using boost::property_tree::ptree;
    using namespace boost;

    string board_name = pt.get<string>("name");
    string board_ip = pt.get<string>("ip");
    string common_filename = "";

    FineHolder holder(id, board_ip);

    for(const auto & p : pt) {
        if(p.first == "configuration") {
            string type = p.second.get<string>("<xmlattr>.type");

            if(type=="BOARD") {
                for(const auto & c : p.second) {
                    if(c.first=="common") {
                        common_filename = std::string(c.second.data());

                        fine::DescriptorCommon* desc = new fine::DescriptorCommon();
                        desc->set_type("COMMON");
                        ptree desc_pt;
                        read_json(common_filename, desc_pt);
                        desc->set_tree(desc_pt);
                        holder.descriptors.push_back(desc);
                    }
                }
            }
            else if(type=="VMM") {
                int vmm_id = std::stoi(p.second.get<string>("<xmlattr>.id"));
                string global_file = "";
                string channel_file = "";
                for(const auto & c : p.second) {
                    if(c.first=="global") {
                        global_file = c.second.data();

                        fine::DescriptorGlobal* desc = new fine::DescriptorGlobal();
                        desc->set_type("GLOBAL");
                        desc->set_vmm_id(vmm_id);
                        ptree desc_pt;
                        read_json(global_file, desc_pt);
                        desc->set_tree(desc_pt);
                        holder.descriptors.push_back(desc);


                    }
                    else if(c.first == "channel") {
                        channel_file = c.second.data();

                        fine::DescriptorChannel* desc = new fine::DescriptorChannel();
                        desc->set_type("CHANNEL");
                        desc->set_vmm_id(vmm_id);
                        ptree desc_pt;
                        read_json(channel_file, desc_pt);
                        desc->set_description(desc_pt.get<string>("vmm_channel_config.description"));
                        desc->set_tree(desc_pt);
                        holder.descriptors.push_back(desc);
                    }
                }
            }
        }
    }

    m_holders.push_back(holder);

}
