#include "raw_data_dumper.h"
#include <bitset>
#include <iostream>
#include <fstream>
using namespace std;

// boost
#include <boost/algorithm/string/replace.hpp>


//////////////////////////////////////////////////////////////////////////////
RawDataDumper::RawDataDumper() :
    m_filename(""),
    m_has_run_properties(false),
    m_ok_to_write(true),
    m_ofile(NULL)
{
}
//////////////////////////////////////////////////////////////////////////////
bool RawDataDumper::open_output_file(std::string filename, int run_number)
{
    cout << "RawDataDumper::open_output_file" << endl;
    bool result = true;

    // expect the root name to be given
    boost::replace_all(filename, ".root", ".bin");
    m_filename = filename;

    // open the file for writing binary
    m_ofile.open(filename.c_str(), std::ios::out | std::ios::binary);

    // first 32 bits will be the run numbgger
    uint32_t write_run = run_number;

    m_ofile.write((char*)(&write_run), sizeof(uint32_t));
    m_ofile.flush();

    if(!result) {
        cout << "RawDataDumper::open_output_file    Error in opening the output file!" << endl;
    }
    m_ok_to_write = true;
    return result;
}
//////////////////////////////////////////////////////////////////////////////
bool RawDataDumper::fill_run_properties(double gain, int tac_slope, int peak_time,
        int dac_threshold, int dac_pulser, int angle, double tp_skew)
{
    bool result = true;
    if(!m_ok_to_write) {
        cout << "RawDataDumper::fill_run_properties    Not filling run properties!" << endl;
        m_has_run_properties = false;
        return false;
    }

    // write the run properties
    float w_gain = static_cast<float>(gain);
    uint32_t w_tac = tac_slope;
    uint32_t w_peak_time = peak_time;
    uint32_t w_dac_threshold = dac_threshold;
    uint32_t w_dac_pulser = dac_pulser;
    uint32_t w_angle = angle;
    float w_tp_skew = tp_skew;

    m_ofile.write((char*)(&w_gain), sizeof(uint32_t));
    m_ofile.write((char*)(&w_tac), sizeof(uint32_t));
    m_ofile.write((char*)(&w_peak_time), sizeof(uint32_t));
    m_ofile.write((char*)(&w_dac_threshold), sizeof(uint32_t));
    m_ofile.write((char*)(&w_dac_pulser), sizeof(uint32_t));
    m_ofile.write((char*)(&w_angle), sizeof(uint32_t));
    m_ofile.write((char*)(&w_tp_skew), sizeof(uint32_t));

    m_ofile.flush();
    m_has_run_properties = true;
    return result;
}
//////////////////////////////////////////////////////////////////////////////
bool RawDataDumper::write_data(uint32_t data_to_write)
{
    m_ofile.write((char*)(&data_to_write), sizeof(uint32_t));
    m_ofile.flush();
    return true;
}
//////////////////////////////////////////////////////////////////////////////
bool RawDataDumper::close_output_file()
{
    bool result = true;
    cout << "RawDataDumper::close_output_file    Closing output raw data file: " <<
            m_filename << endl;

    m_ofile.close();
    m_ofile.flush();
    return result;
}
